#class Numeric of Ruby
class Numeric
	#returns:: this number
	#This method is defined in the API of SketchUp in order to work with meters instead of inches. When this command is used, we are working without SkethUp,
	#so we do not need this conversion. We define thus this method for avoiding errors when the invocations of .m are done; since Ruby does not define it.
	#Obviously, when SketchUp is not being used, this method does not do anything, returning the same number.
	def m
		return self
	end
end

require "#{File.dirname(__FILE__)}/../main-structures"
require "#{File.dirname(__FILE__)}/../utils"

Shade.using_sketchup = false


#Create the project
ShadeUtils.create_default_project

#Add constraint and goal names
ShadeUtils.add_cg_names()

#Search for custom constraints
ShadeUtils.load_custom_constraints()

#Search for custom goals
ShadeUtils.load_custom_goals()

project_directory = "#{File.dirname(__FILE__)}/temp/project.txt"
Shade.project.load(project_directory.gsub("/", "\\"))

Shade.project.execution.reset

current_shape_directory = "#{File.dirname(__FILE__)}/temp/current_shape.txt"
Shade.project.execution.current_shape.load(current_shape_directory.gsub("/", "\\"))
Shade.project.execution.current_shape.create_pi

history_directory = "#{File.dirname(__FILE__)}/temp"
history_directory.gsub!("/", "\\")
Shade.project.execution.load_execution_history(history_directory)

#Delete files of temporal directory
dir = Dir.new("#{File.dirname(__FILE__)}/temp")
dir.each { |file_name|
	if file_name == '.' or file_name == '..' then next
	else File.delete("#{File.dirname(__FILE__)}/temp/#{file_name}")
	end
}

n_applied = Shade.project.execution.apply_n_rules_random(ARGV.first.to_i, false)

log_directory = "#{File.dirname(__FILE__)}/temp/result.log"

if n_applied
	Shade.project.execution.current_shape.save(current_shape_directory.gsub("/", "\\"))
	File.open(log_directory.gsub("/", "\\"), 'w') do |f|
		f.write "#{Shade.project.execution.backtracking_steps}"
	end
	Shade.project.execution.save_execution_history(history_directory)
else
	File.open(log_directory.gsub("/", "\\"), 'w') do |f|
		f.write "false"
	end
end
